/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.block.entity.AerialInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AerialInterfaceMenu;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AerialInterfaceScreen
extends AbstractPneumaticCraftContainerScreen<AerialInterfaceMenu, AerialInterfaceBlockEntity> {
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[AerialInterfaceBlockEntity.FeedMode.values().length];
    private WidgetButtonExtended xpButton;
    private WidgetAnimatedStat feedModeTab;

    public AerialInterfaceScreen(AerialInterfaceMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingRF.info.title", new Object[0]), Textures.GUI_BUILDCRAFT_ENERGY, -6282718, false).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.aerialInterface.interfacingRF.info", new Object[0]));
        ((AerialInterfaceBlockEntity)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> this.m_142416_((GuiEventListener)new WidgetEnergy(this.f_97735_ + 20, this.f_97736_ + 20, (IEnergyStorage)storage)));
        if (((AerialInterfaceBlockEntity)this.te).dispenserUpgradeInserted) {
            List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (availableXp.size() > 0) {
                WidgetAnimatedStat xpStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.liquidXp.info.title", new Object[0]), new ItemStack((ItemLike)Items.f_42612_), -11141291, false);
                xpStat.setText(this.getLiquidXPText()).setForegroundColor(-16777216);
                this.xpButton = new WidgetButtonExtended(20, 15, 20, 20, TextComponent.f_131282_, b -> {
                    ++((AerialInterfaceBlockEntity)this.te).curXPFluidIndex;
                    if (((AerialInterfaceBlockEntity)this.te).curXPFluidIndex >= availableXp.size()) {
                        ((AerialInterfaceBlockEntity)this.te).curXPFluidIndex = -1;
                    }
                    this.setupXPButton();
                }).withTag("xpType");
                this.setupXPButton();
                xpStat.addSubWidget((AbstractWidget)this.xpButton);
                xpStat.setReservedLines(3);
            }
            this.feedModeTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(((AerialInterfaceBlockEntity)this.te).feedMode.getTranslationKey(), new Object[0]), ((AerialInterfaceBlockEntity)this.te).feedMode.getIconStack(), -24576, false);
            this.feedModeTab.setMinimumExpandedDimensions(80, 42);
            for (int i = 0; i < AerialInterfaceBlockEntity.FeedMode.values().length; ++i) {
                AerialInterfaceBlockEntity.FeedMode mode = AerialInterfaceBlockEntity.FeedMode.values()[i];
                ArrayList<Component> l = new ArrayList<Component>();
                l.add((Component)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).m_130940_(ChatFormatting.YELLOW));
                l.addAll(GuiUtils.xlateAndSplit(mode.getDescTranslationKey(), new Object[0]));
                WidgetButtonExtended button = new WidgetButtonExtended(5 + 25 * i, 20, 20, 20).withTag(mode.toString()).setRenderStacks(mode.getIconStack()).setTooltipText(l);
                this.feedModeTab.addSubWidget((AbstractWidget)button);
                this.modeButtons[i] = button;
            }
            this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingFood", new Object[0]), new ItemStack((ItemLike)Items.f_42406_), -6250336, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.removeDispenser", new Object[0])).setForegroundColor(-16777216);
        } else {
            this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingItems", new Object[0]), new ItemStack((ItemLike)Blocks.f_50087_), -6250336, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.insertDispenser", new Object[0])).setForegroundColor(-16777216);
            Arrays.fill(this.modeButtons, null);
        }
    }

    @Override
    protected boolean shouldAddSideConfigTabs() {
        return !((AerialInterfaceBlockEntity)this.te).dispenserUpgradeInserted;
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (((AerialInterfaceBlockEntity)this.te).dispenserUpgradeInserted) {
            if (this.modeButtons[0] != null) {
                for (int i = 0; i < this.modeButtons.length; ++i) {
                    this.modeButtons[i].f_93623_ = ((AerialInterfaceBlockEntity)this.te).feedMode != AerialInterfaceBlockEntity.FeedMode.values()[i];
                }
                this.feedModeTab.m_93666_((Component)PneumaticCraftUtils.xlate(((AerialInterfaceBlockEntity)this.te).feedMode.getTranslationKey(), new Object[0]));
            } else {
                this.refreshScreen();
            }
        } else if (this.modeButtons[0] != null) {
            this.refreshScreen();
        }
    }

    private void setupXPButton() {
        Fluid fluid;
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        Fluid fluid2 = fluid = ((AerialInterfaceBlockEntity)this.te).curXPFluidIndex >= 0 && ((AerialInterfaceBlockEntity)this.te).curXPFluidIndex < availableXp.size() ? availableXp.get(((AerialInterfaceBlockEntity)this.te).curXPFluidIndex) : Fluids.f_76191_;
        if (fluid != Fluids.f_76191_) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            this.xpButton.setRenderStacks(FluidUtil.getFilledBucket((FluidStack)fluidStack));
            String modName = ModNameCache.getModName(fluid.getRegistryName().m_135827_());
            this.xpButton.setTooltipText((List<Component>)ImmutableList.of((Object)fluidStack.getDisplayName(), (Object)new TextComponent(modName).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.BLUE})));
        } else {
            this.xpButton.setRenderStacks(new ItemStack((ItemLike)Items.f_42446_));
            this.xpButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.aerial_interface.xpDisabled", new Object[0]));
        }
    }

    private List<Component> getLiquidXPText() {
        ArrayList<Component> liquidXpText = new ArrayList<Component>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.aerialInterface.liquidXp.info", new Object[0]));
        liquidXpText.add(TextComponent.f_131282_);
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        if (availableXp.isEmpty()) {
            liquidXpText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}));
        } else {
            for (Fluid f : availableXp) {
                FluidStack stack = new FluidStack(f, 1000);
                String modName = ModNameCache.getModName(f.getRegistryName().m_135827_());
                TextComponent modNameText = new TextComponent(" (" + modName + ")");
                liquidXpText.add((Component)Symbols.bullet().m_130940_(ChatFormatting.BLACK).m_7220_((Component)stack.getDisplayName().m_6881_().m_130940_(ChatFormatting.BLACK)).m_7220_((Component)modNameText.m_130940_(ChatFormatting.DARK_BLUE)));
            }
        }
        return liquidXpText;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((AerialInterfaceBlockEntity)this.te).getPressure() >= ((AerialInterfaceBlockEntity)this.te).getMinWorkingPressure() && ((AerialInterfaceBlockEntity)this.te).isConnectedToPlayer) {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", PneumaticCraftUtils.roundNumberTo(1.0, 1)).m_130940_(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((AerialInterfaceBlockEntity)this.te).getPlayerName().isEmpty()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.aerialInterface.noPlayer", new Object[0]));
        } else if (!((AerialInterfaceBlockEntity)this.te).isConnectedToPlayer) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.aerialInterface.playerOffline", ((AerialInterfaceBlockEntity)this.te).getPlayerName()));
        }
    }

    @Override
    protected void addInformation(List<Component> curInfo) {
        if (((AerialInterfaceBlockEntity)this.te).getPlayerName() != null && !((AerialInterfaceBlockEntity)this.te).getPlayerName().isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.linked", ((AerialInterfaceBlockEntity)this.te).getPlayerName()));
        }
    }
}

